#         _____
#         (o o)
#          | |
#       __/===\__
# \    //|     |\\
#  \===| |     | |===\
#      \\|     |//    \
#        \=====/
#       / / | \ \
#      <_________>

# dependency of the exchange.  see api documentation at your chosen exchange
import mexc_spot_v3

# dependencies from python built in
import requests
import time

# get the public api url for your exchange and enter it here:
hosts = ""
# i.e. https://api.mexc.com

def main():
    FILENAME = input('Enter filename for output. Ex govbot.backup.txt')
    THRESHOLD = float(input('Enter threshold.  Ex. 5 is 5%'))

    # connect and grab BTC_USD average price and put it in a float variable:
    try:
        data = mexc_spot_v3.mexc_market(mexc_hosts=hosts)
		# 'symbol' must match the format of your exchange.  see api documentation there.
        BTC_USD_CURRENT_AVG_PRICE = data.get_avgprice({'symbol': 'BTCUSD'})

        BTC_USD_PRICE = float(BTC_USD_CURRENT_AVG_PRICE.get('price'))
    except:
        print('could not receive current BTC_USD price')

    btc_usd_buy_threshold = (100 - THRESHOLD) / 100
    btc_usd_sell_threshold = (100 + THRESHOLD) / 100
    btc_usd_buy_target = BTC_USD_PRICE * btc_usd_buy_threshold
    btc_usd_sell_target = BTC_USD_PRICE * btc_usd_sell_threshold

    with open(FILENAME, "w") as backup:
        print(BTC_USD_PRICE, file=backup)
        print(btc_usd_buy_target, file=backup)
        print(btc_usd_sell_target, file=backup)
        print(btc_usd_buy_target, file=backup)
        print(btc_usd_sell_target, file=backup)
        print('0', file=backup)
        print('0', file=backup)
    print('File created.')
    
if __name__ == "__main__":
        main()