#         _____
#         (o o)
#          | |
#       __/===\__
# \    //|     |\\
#  \===| |     | |===\
#      \\|     |//    \
#        \=====/
#       / / | \ \
#      <_________>

# dependent on your exchange.  in this case, i've downloaded the necessary dependency and it is in a file in the same directory as this script.  this allows the script below to talk to the exchange.
import mexc_spot_v3 

# dependencies from built in python stuff
import time
import requests
import os ; from os import system, name
import json
import colorama ; from colorama import Fore ; from colorama import Style; from colorama import init; colorama.init()
init(autoreset=True)

################################ useful documentation for mexc exchange in particular.  you should find similar for your exchange

# https://mxcdevelop.github.io/apidocs/
# https://github.com/mxcdevelop/mexc-api-sdk/tree/main/test/python
# https://github.com/mxcdevelop/mexc-api-demo/blob/main/python/spot/v3/test_v3.py
# https://github.com/mxcdevelop/mexc-api-demo/blob/main/python/spot/v3/mexc_spot_v3.py
##################################

# sign up for an api key through your account at your exchange.  enter the api url here
hosts = ""
# i.e. https://api.mexc.com

# *******obtain exchange key and enter here:************
exchange_key = ""
# ******obtain exchange secret and enter here:********
exchange_secret = ""


# These must be in same folder as script to work as written
BACKUP_FILENAME = 'govbot1.backup.txt'
LOG_FILENAME = 'govbot1.log.txt'


# defines the number of seconds between each tick.  bot checks every [period] seconds for price and whether it will buy sell.  if the price goes down a lot for instance, bot will keep buying at this frequency
PERIOD = 61  # seconds

# find out what the fee for the exchange is and enter it here, so the bot doesn't do anything 'unprofitable'.  it will calculate it in when deciding buys and sells
FEE = 0.002 # %

# an approximate price to be used as a default.  gets replaced by the real current price in normal operation but won't break if bot doesn't initially connect to exchange price feed api on the first tick.
BTC_USD_PRICE = 0.0000001

    # connect and grab BTC USD average price and put it in a float variable.
try:
	#must be adapted for your exchange.  look at the api documentation there.  'data' and 'data.get_avgprice' and 'get' may not be the specific terms your exchange uses.
    data = mexc_spot_v3.mexc_market(mexc_hosts=hosts)
    BTC_USD_CURRENT_AVG_PRICE = data.get_avgprice({'symbol': 'BTCUSDT'})
    BTC_USD_PRICE = float(BTC_USD_CURRENT_AVG_PRICE.get('price'))
    time.sleep(2)
except:
    print('could not receive current BTC_USD price')
    time.sleep(2)

    

# value amount of each trade.  bot will break if price change causes this amount to be less than exchange's minimum trade amount.  If BTC price is 100,000, 10,000/100,000 = $10 per trade.  Some exchanges have a $5 minimum trade or so.

BTC_USD_QUANTITY = 10000 / BTC_USD_PRICE

# how far below or above the actual price will the bot set an order to attempt to get it filled?  if it looks for the exact price at this moment, then tries to get a trade filled at that exact price, the market may have already moved by then.  this is known as slippage.  to remedy this, place a buy above the current price, or a sell below the current price, to make it more likely to fill.  Defaults are good for an exchange with reasonable volume.
BUY_FILLED_VS_SLIPPAGE = 1.0075
SELL_FILLED_VS_SLIPPAGE = 0.9925

# how far above or below a previously attempted (probably filled if slippage variable is dialed in) trade should the price be before the bot tries another trade?  if too small, bot will buy every tick for a long time on a big price move, possibly running out of funds fast.  to large, bot will not make many trades.  this is the main variable that will define your profit over time.
MOVE_UP = 1.005
MOVE_DOWN = 0.995

def main():
    append_to_log('New bot run.', LOG_FILENAME)

    tick_counter = 0
    
    while True:
        start = time.time()
        if tick_counter == 0:
            try:
                data = mexc_spot_v3.mexc_market(mexc_hosts=hosts)
                BTC_USD_CURRENT_AVG_PRICE = data.get_avgprice({'symbol': 'BTCUSD'})

                BTC_USD_PRICE = float(BTC_USD_CURRENT_AVG_PRICE.get('price'))
                btc_usd_price_tick_success = True
                time.sleep(1)
            except:
                print('could not receive current BTC_BTC price')
                btc_usd_price_tick_success = False
                time.sleep(1)

		# in case you have to restart the bot, this backup keeps all of your data.  because of this feature, the bot needs initial values.  therefore you must run make.backup.py before your first run, and if you want to ever reset stats.  You can also just learn the format of the backup file and create one manually.
            try:
                with open(BACKUP_FILENAME, "r") as backup:
                    init_btc_usd_price = float(backup.readline())
                    init_btc_usd_buy_target = float(backup.readline())
                    init_btc_usd_sell_target = float(backup.readline())
                    btc_usd_buy_target = float(backup.readline())
                    btc_usd_sell_target = float(backup.readline())
                    btc_usd_buy_count = int(backup.readline())
                    btc_usd_sell_count = int(backup.readline())
            except Exception as e:
                print(e)
                append_to_log('Could not load backup.  Restart', LOG_FILENAME)
                append_to_log(e, LOG_FILENAME)
                raise Exception('Could not load backup.  Restart')
    
        os.system('cls||clear')

        try:
            
            #################### BTCUSD ##########################
            # connect and grab BTCUSD average price and put it in a float variable:                
            try:
                data = mexc_spot_v3.mexc_market(mexc_hosts=hosts)
			# 'symbol' must match your exchange's format for ticker symbols
                BTC_USD_CURRENT_AVG_PRICE = data.get_avgprice({'symbol': 'BTCUSD'})

                BTC_USD_PRICE = float(BTC_USD_CURRENT_AVG_PRICE.get('price'))
                btc_usd_price_tick_success = True
                time.sleep(1)
            except:
                print('could not receive current BTC_USD price')
                btc_usd_price_tick_success = False
                time.sleep(1)
            	# sell target will keep moving as sells get made.  in this way, you keep selling BTC_USD_QUANTITY as the price goes up by MOVE_UP amount.
            if BTC_USD_PRICE > btc_usd_sell_target and btc_usd_price_tick_success == True:
                price = BTC_USD_PRICE
                current_price = BTC_USD_PRICE
                price *= SELL_FILLED_VS_SLIPPAGE 
                print(Fore.RED + ' * Selling BTC_USD')
                side = 'SELL'
                quantity = BTC_USD_QUANTITY
                trade = mexc_spot_v3.mexc_trade(exchange_key=exchange_key, exchange_secret=exchange_secret, mexc_hosts=hosts)
                market = 'BTCUSD'
                params = {
                    "symbol": market,
                    "side": side,
                    "type": "LIMIT",
                    "quantity": quantity,
                    "price": current_price * SELL_FILLED_VS_SLIPPAGE,
                    "recvWindow": 10000
                }
                response=trade.post_order(params)
                # print(' * ', response)
                try:
                    id = response['orderId']
                    params = {
                        "symbol": 'BTCUSD',
                        "orderId" : id
                    }
                    got = trade.get_order(params)
                    # print(got)
                    if got['status'] == "FILLED":
                        print('* Successfully sent a sell order, and it shows as FILLED!')
                        usd_buy_target *= MOVE_UP
                        btc_usd_sell_target *= MOVE_UP
                        btc_usd_sell_count += 1
                        print(' * BTC_USD Buytarget:', floaty5(btc_usd_buy_target), 'Selltarget:', floaty5(btc_usd_sell_target))
                        append_to_log('Sold BTC_USD.', LOG_FILENAME)
                except:
                    print('could not sell BTC_USD - probably out of funds')
            
	    	# buy target will keep moving as buys get made.  in this way, you keep buying BTC_USD_QUANTITY as the price goes down by MOVE_DOWN amount.
            if BTC_USD_PRICE < btc_usd_buy_target and btc_usd_price_tick_success == True:
                price = BTC_USD_PRICE
                current_price = BTC_USD_PRICE
                price *= BUY_FILLED_VS_SLIPPAGE 
                print(Fore.RED + ' * Buying BTC_USD')
                side = 'BUY'
                quantity = BTC_USD_QUANTITY
                trade = mexc_spot_v3.mexc_trade(exchange_key=exchange_key, exchange_secret=exchange_secret, mexc_hosts=hosts)
                market = 'BTCUSD'
                params = {
                    "symbol": market,
                    "side": side,
                    "type": "LIMIT",
                    "quantity": quantity,
                    "price": current_price * BUY_FILLED_VS_SLIPPAGE,
                    "recvWindow": 10000
                }
                response=trade.post_order(params)
                # print(' * ', response)
                try:
                    id = response['orderId']
                    params = {
                        "symbol": 'BTCUSD',
                        "orderId" : id
                    }
                    got = trade.get_order(params)
                    # print(got)
                    if got['status'] == "FILLED":
                        print('* Successfully sent a buy order, and it shows as FILLED!')
                        btc_usd_buy_target *= MOVE_DOWN
                        btc_usd_sell_target *= MOVE_DOWN
                        btc_usd_buy_count += 1                    
                        print(' * BTC_USD Buytarget:', floaty5(usd_buy_target), 'Selltarget:', floaty5(btc_usd_sell_target))
                        append_to_log('Bought BTC_USD.', LOG_FILENAME)
                except:
                    print('could not buy BTC_USD - probably out of funds')

#################### PRINTER SHOWS PROGRESS ON SCREEN ##########################
            run_days = (tick_counter / 60) / 24
            print(Fore.YELLOW + 'GovBot', '| Period:', PERIOD, '|', time.ctime(), '|', 'Tick Count:', tick_counter, '|', 'Run Days:', floaty2(run_days))
            print()
            print('Initial values:')
            print()
            print('{:^5} {:<8} {:>10} {:>10} {:>10}'.format('  ', 'PAIR','BUYTARGET', 'PRICE', 'SELLTARGET'))
            print('{:^5} {:<8} {:>10} {:>10} {:>10}'.format('  ', '----','---------', '-----', '----------'))
            print('{:^5} {:<8} {:>10} {:>10} {:>10}'.format('--', 'BTCUSD', floaty5(init_btc_usd_buy_target), floaty5(init_btc_usd_price), floaty5(init_btc_usd_sell_target)))            
            print()
            print('Current values:')
            print()
            print('{:^5} {:<8} {:>10} {:^10} {:^10} {:^10}'.format('   ', 'PAIR', 'BUYTARGET', 'BUYCOUNT', 'SELLCOUNT', 'SELLTARGET'))
            print('{:^5} {:<8} {:>10} {:^10} {:^10} {:^10}'.format('   ', '----', '---------', '--------', '---------', '----------'))
            print('{:^5} {:<8} {:>10} {:^10} {:^10} {:^10}'.format('---', 'BTCUSD', floaty5(btc_usd_buy_target), btc_usd_buy_count, btc_usd_sell_count, floaty5(btc_usd_sell_target)))
            print('{:^12} {:^46}'.format('            ', progress_printer(btc_usd_buy_target, btc_usd_sell_target, BTC_USD_PRICE, 'Ƀ')))
            print()            
            print()
            total_buys = btc_usd_buy_count
            total_sells = btc_usd_sell_count
            approx_profit = ((total_buys + total_sells) / 2) * (12 * 0.055)
            print('Total Buys:', total_buys)
            print('Total Sells:', total_sells)
            print('Approx Profit:', '$', floaty2(approx_profit))
            
            with open(BACKUP_FILENAME, "w") as backup:
                print(init_btc_usd_price, file=backup)
                print(init_btc_usd_buy_target, file=backup)
                print(init_btc_usd_sell_target, file=backup)
                print(btc_usd_buy_target, file=backup)
                print(btc_usd_sell_target, file=backup)
                print(btc_usd_buy_count, file=backup)
                print(btc_usd_sell_count, file=backup)

        except Exception as e:
            print(e)
            append_to_log('Unknown error, retry next tick.', LOG_FILENAME)
            append_to_log(e, LOG_FILENAME)
    
        end = time.time()

        if end - start < PERIOD:
            time.sleep(PERIOD - (end - start))
    
        tick_counter += 1

def append_to_log(string_to_print, logfile_name):
    with open(LOG_FILENAME, "a") as log:
        print('---------------', file=log)
        print(time.ctime(), file=log)
        print(string_to_print, file=log)

def progress_printer(buy_target, sell_target, printprice, symbol):
    gap = sell_target - buy_target
    center = (sell_target + buy_target) / 2
    if printprice > center:
        dist = printprice - center
        percent_there = dist / (gap / 2)
        printprice = floaty(printprice)
        printprice = f'{printprice:{9}.{9}}'
        if percent_there < 0.1:
            return str(Fore.GREEN + '|<···············<-' + symbol + printprice + Fore.GREEN + '->················>|')
        elif percent_there < 0.2:
            return str(Fore.GREEN + '|<·················<-' + symbol + printprice + Fore.GREEN + '->··············>|')
        elif percent_there < 0.3:
            return str(Fore.GREEN + '|<···················<-' + symbol + printprice + Fore.GREEN + '->············>|')
        elif percent_there < 0.4:
            return str(Fore.GREEN + '|<·····················<-' + symbol + printprice + Fore.GREEN + '->··········>|')
        elif percent_there < 0.5:
            return str(Fore.GREEN + '|<·······················<-' + symbol + printprice + Fore.GREEN + '->········>|')
        elif percent_there < 0.6:
            return str(Fore.GREEN + '|<·························<-' + symbol + printprice + Fore.GREEN + '->······>|')
        elif percent_there < 0.7:
            return str(Fore.GREEN + '|<···························<-' + symbol + printprice + Fore.GREEN + '->····>|')
        elif percent_there < 0.8:
            return str(Fore.GREEN + '|<·····························<-' + symbol + printprice + Fore.GREEN + '->··>|')
        elif percent_there < 0.9:
            return str(Fore.GREEN + '|<······························<-' + symbol + printprice + Fore.GREEN + '->·>|')
        else:
            return str(Fore.GREEN + '|<································<-' + symbol + printprice + Fore.GREEN + '->|')
    else:
        dist = center - printprice
        percent_there = dist / (gap / 2)
        printprice = floaty(printprice)
        printprice = f'{printprice:{9}.{9}}'
        if percent_there < 0.1:
            return str(Fore.RED + '|<················<-' + symbol + printprice + Fore.RED + '->···············>|')
        elif percent_there < 0.2:
            return str(Fore.RED + '|<··············<-' + symbol + printprice + Fore.RED + '->·················>|')
        elif percent_there < 0.3:
            return str(Fore.RED + '|<············<-' + symbol + printprice + Fore.RED + '->···················>|')
        elif percent_there < 0.4:
            return str(Fore.RED + '|<··········<-' + symbol + printprice + Fore.RED + '->·····················>|')
        elif percent_there < 0.5:
            return str(Fore.RED + '|<········<-' + symbol + printprice + Fore.RED + '->·······················>|')
        elif percent_there < 0.6:
            return str(Fore.RED + '|<······<-' + symbol + printprice + Fore.RED + '->·························>|')
        elif percent_there < 0.7:
            return str(Fore.RED + '|<····<-' + symbol + printprice + Fore.RED + '->···························>|')
        elif percent_there < 0.8:
            return str(Fore.RED + '|<··<-' + symbol + printprice + Fore.RED + '->·····························>|')
        elif percent_there < 0.9:
            return str(Fore.RED + '|<·<-' + symbol + printprice + Fore.RED + '->······························>|')
        else:
            return str(Fore.RED + '|<-' + symbol + printprice + Fore.RED + '->································>|')

def floaty(f):
    return "%.8f" % f
    
def floaty2(f):
    return "%.2f" % f    
    
def floaty5(f):
    return "%.5f" % f
    
def floaty6(f):
    return "%.6f" % f
    
def floaty1(f):
    return "%.1f" % f  
    
def floaty0(f):
    return "%.0f" % f   

if __name__ == "__main__":
        main()
        